#!/bin/bash

#############################################################
# Linux Client UnInstaller Script
#############################################################

# variables defined in .defaults
# APP_BASENAME = human-readable application name
# DIR_BASENAME = dir name
# DOWNLOAD_HOST = where to get the jre

SCRIPT_DIR=`dirname ${0}`
. ${SCRIPT_DIR}/.defaults

BINSLOC="/bin /usr/bin /usr/local/bin"
REQDBINS="grep sed cpio gzip cut head tail who wget"

TARGETDIR=/usr/local/${DIR_BASENAME}
BINSDIR=/usr/local/bin
MANIFESTDIR=/usr/local/var/${DIR_BASENAME}
INITDIR=/etc/init.d
RUNLEVEL=`who -r | sed -e 's/^.*\(run-level [0-9]\).*$/\1/' | cut -d \  -f 2`
RUNLVLDIR=/etc/rc${RUNLEVEL}.d

SRC_USER=${SUDO_USER}
if [ "x${SRC_USER}" == "x" ] ; then
	SRC_USER=${USER}
fi

# required installation directory parameter
if [ "x${1}" == "x" ] ; then
	echo ""
	echo "Usage: uninstall.sh installation_dir"
	echo ""
	echo "Please specify where ${APP_BASENAME} was installed."
	exit 1
fi

# check for the install.vars file
if [ ! -f ${1}/install.vars ] ; then
	echo ""
	echo "${APP_BASENAME} was not found at ${1}.  Please specify where ${APP_BASENAME} was installed."
	exit 1
fi

if [ "${2}" != "recall" ] ; then
	echo ""
	echo "${APP_BASENAME} Uninstaller."
	echo ""
	echo -n "Press enter to continue. "
	read ENTER
fi

# required binaries
#echo ""
#echo "Validating environment"
#echo -n "  searching for ... " 
for bin in ${REQDBINS} ; do
	BINOK=0
#	echo -n "${bin} "
	for binpath in ${BINSLOC} ; do
		if [ -f ${binpath}/${bin} ] ; then
			BINOK=1
		fi
	done
	if [ ${BINOK} == 0 ] ; then
		echo ""
		echo "ERROR: ${bin} not found and is required for uninstall. Exiting"
		exit 1
	fi
done
#echo ""

# check for root permissions
if [ "${USER}" != "root" ] ; then
	echo ""
	echo "NOTE: You are apparently not uninstalling as root. If ${APP_BASENAME}"
	echo "was installed as root you will need root permissions to clean up"
	echo "all of the ${APP_BASENAME} files."
	echo ""
	echo -n "Would you like to switch users and uninstall as root? (y/n) [y] "
	read YN
	if [ "x${YN}" == "x" ] ; then
		YN=y
	fi
	
	if [ "${YN}" == "y" ] ; then
		echo "  switching to root"
		sudo ${0} ${1} recall
		exit 0
	else
		echo "  uninstalling as ${USER}"
		
		TARGETDIR=${HOME}/${DIR_BASENAME}
		BINSDIR=
		MANIFESTDIR=${HOME}/${DIR_BASENAME}/manifest
		INITDIR=
		RUNLVLDIR=
	fi
else
	echo "  detected root permissions"
fi

echo ""
echo "============================================================================"
echo "Step 1:  Software Removal - WARNING WARNING WARNING" 
echo "============================================================================"
echo "This portion of the uninstall will remove ${APP_BASENAME} software and configuration"
echo "information.  Automatic backup will cease."
echo ""
echo -n "Are you sure you wish to continue? (yes/no) [no] "
read YN
if [ "${YN}" == "yes" ] ; then
	echo "Uninstalling ${APP_BASENAME} ... "
	. ${1}/install.vars
	if [ "x${TARGETDIR}" == "x" ] ; then
		echo "ERROR: Conf file not loaded correctly."
		exit 1
	fi
	HERE=`pwd`
	cd "${TARGETDIR}"
	${TARGETDIR}/bin/${APP_BASENAME}Engine stop
	if [ "x${BINSDIR}" != "x" ] ; then
		rm -f ${RUNLVLDIR}/S99${DIR_BASENAME}
		rm -f ${INITDIR}/${DIR_BASENAME}		
		rm -f ${BINSDIR}/${APP_BASENAME}Desktop
	fi
	cd ${HERE}
	rm -r -f ${TARGETDIR}
	
	# check for the desktop launcher and take that too
	if [ -f "/home/${SRC_USER}/Desktop/${APP_BASENAME}.desktop" ] ; then
		rm -rf "/home/${SRC_USER}/Desktop/${APP_BASENAME}.desktop"
	fi
	
	# strip out the keys
	user="false"
	identityFile=/var/lib/${DIR_BASENAME}/.identity
	if [ ! -f "$identityFile" ] ; then
	  identityFile=/home/${SRC_USER}/.${DIR_BASENAME}/.identity
	  user="true"
	fi
	if [ -f "$identityFile" ] ; then
		sed -e '/privateKey/ d' -e '/publicKey/ d' -e '/securityKeyType/ d' "$identityFile" > "${identityFile}.tmp"
		mv "${identityFile}.tmp" "$identityFile"
		chmod 600 "$identityFile"
		if [ "${user}" == "true" ] ; then
			chown ${SRC_USER}:${SRC_USER} ${identityFile}
		fi
	fi
	
	echo "${APP_BASENAME} uninstalled."
	
	echo ""
	echo ""
	echo "============================================================================"
	echo "Step 2:  Backup Data Removal - WARNING WARNING WARNING" 
	echo "============================================================================"
	echo -n "Would you like to remove all backup data? (yes/no) [no] "
	read YN
	if [ "${YN}" == "yes" ] ; then
		echo "Removing ${APP_BASENAME} backup data... "
		rm -r -f ${MANIFESTDIR}
		echo "${APP_BASENAME} backup data removed."
	else
		echo ""
		echo ""
		echo "The backup data was NOT removed.  It is located in ${MANIFESTDIR}."
		echo "If you reinstall ${APP_BASENAME}, you will need to note that as the location"
		echo "where you would like to store your backups if you wish to start where"
		echo "you left off."
	fi
		
fi

echo ""
echo "${APP_BASENAME} uninstallation is complete."
echo ""

